#include <iostream>
#include <map>
#include <utility>

using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N;
    if (!(cin >> N)) return 0;

    map<int, pair<long long, long long>> y_groups; 
    map<int, pair<long long, long long>> x_groups;
    map<int, long long> diag_groups;
    map<int, long long> anti_diag_groups;

    for (int i = 0; i < N; ++i) {
        int x, y;
        cin >> x >> y;

        if (x % 2 == 0) {
            y_groups[y].first++;
        } else {
            y_groups[y].second++;
        }
        if (y % 2 == 0) {
            x_groups[x].first++;
        } else {
            x_groups[x].second++;
        }

        diag_groups[x - y]++;
        anti_diag_groups[x + y]++;
    }

    long long total_greetings = 0;

    auto calculate_greetings = [](long long M) -> long long {
        if (M < 2) return 0;
        return M * (M - 1);
    };

    for (const auto& entry : y_groups) {
        total_greetings += calculate_greetings(entry.second.first);
        total_greetings += calculate_greetings(entry.second.second);
    }
    for (const auto& entry : x_groups) {
        total_greetings += calculate_greetings(entry.second.first);
        total_greetings += calculate_greetings(entry.second.second);
    }
    for (const auto& entry : diag_groups) {
        total_greetings += calculate_greetings(entry.second);
    }
    for (const auto& entry : anti_diag_groups) {
        total_greetings += calculate_greetings(entry.second);
    }

    cout << total_greetings << endl;

    return 0;
}